//Experiment - 5
//Designing of FIR filters for low pass, high pass, band pass and band reject response.

// To Design an High Pass FIR Filter
//Filter Length =5, Order = 4
//Window = Rectangular Window

clc;
clear;
xdel(winsid());
fc = input("Enter Analog cutoff freq. in Hz=")//250
fs = input("Enter Analog sampling freq. in Hz=")//2000
M = input("Enter order of filter =")//4
w = (2*%pi)*(fc/fs);
disp(w,'Digital cutoff frequency in radians.cycles/samples');
wc = w/%pi;
disp(wc,'Normalized digital cutoff frequency in cycles/samples');
[wft,wfm,fr]=wfir('hp',M+1,[wc/2,0],'re',[0,0]);
disp(wft,'Impulse Response of HPF FIR Filter:h[n]=');
//Plotting the Magnitude Response of HPF FIR Filter
subplot(2,1,1)
plot(2*fr,wfm)
xlabel('Normalized Digital Frequency w--->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR HPF')
xgrid(1)
subplot(2,1,2)
plot(fr*fs,wfm)
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR HPF')
xgrid(1)